<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Beneficiary extends Model 
{

    protected $table = 'beneficiaries';
    public $timestamps = true;
    protected $fillable = array('cprf', 'full_name', 'presentation_name', 'email');
    protected $visible = array('cprf', 'full_name', 'presentation_name', 'email');

    public function address()
    {
        return $this->hasOne('BenefeciaryAddress', 'beneficiary_id');
    }

    public function bank_accounts()
    {
        return $this->hasMany('BankAccount');
    }

}